document.addEventListener('DOMContentLoaded', function() {
    const input = document.getElementById('gatewayInput');
    const abrirBtn = document.getElementById('abrirBtn');
    const visualizarBtn = document.getElementById('visualizarBtn');
    
    // 1. LER O VALOR SALVO (chrome.storage)
    // Se houver um IP salvo, ele preenche o campo de input
    chrome.storage.sync.get(['gatewayIP'], function(result) {
        if (result.gatewayIP) {
            input.value = result.gatewayIP;
        }
    });

    // 2. FUNÇÃO PARA ABRIR O ROTEADOR
    abrirBtn.addEventListener('click', function() {
        let ip = input.value.trim();
        
        if (ip) {
            // Salva o IP digitado para uso futuro
            // ESTA É A PARTE QUE FAZ A EXTENSÃO LEMBRAR O IP
            chrome.storage.sync.set({ 'gatewayIP': ip }, function() {
                console.log('IP Salvo com Sucesso!');
            });
            
            // Abre o IP em uma nova aba (Garante que tenha 'http://')
            let url = ip.startsWith('http') ? ip : `http://${ip}`;
            chrome.tabs.create({ url: url });
        } else {
            alert('Por favor, digite o endereço do Gateway Padrão.');
        }
    });
    
    // 3. FUNÇÃO PARA EXPLICAR COMO VER O IP
    visualizarBtn.addEventListener('click', function() {
        // Abre um link com instruções para encontrar o Gateway Padrão
        chrome.tabs.create({ url: 'https://www.google.com/search?q=como+achar+gateway+padrão' });
    });
});